<xsl:transform version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"		
		xmlns:mx="http://www.mobotix.com/xslfuncs">
		
<xsl:output method="html" encoding="UTF-8"/>

<xsl:variable name="translation-context">UploadAssistant</xsl:variable> 
<xsl:include href="include.xsl"/>
<xsl:include href="table.xsl"/>

<xsl:template match="/print">

<html>
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
  <style>
	BODY, TD, TH {
	  	font-family: "VAGRounded LT Thin";
  		font-size: 11pt;
  		color: #002080;
	}
  	TD,TH {
  		text-align:left;
  	}
  	TH {
  		background-color: #eeeeee;
  		text-align: center;
  	}
  	P {
  		text-align:center;
  	}
  	hr {
  		color: #002080;
  		height: 2px;  			
  	}
  	.title {
		font-weight:bold;
		font-size:24pt;
		background-color: #dddddd;
		vertical-align:middle;
	}
  	.header {
  		position: absolute;
  		top:0px;
  	}
  </style>
</head>

<body>
<center>

<table cellspacing="0" border="0" width="100%">
<tr>
	<td class="title" align="center">
		<xsl:call-template name="tr"><xsl:with-param name="source">Update Assistant - Camera List</xsl:with-param></xsl:call-template>
	</td>
	<td width="180" align="right" bgcolor="#dddddd">
		<img width="175" height="146" border="0">
			<xsl:attribute name="src"><xsl:value-of select="template-path"/>logo.jpg</xsl:attribute>
		</img>
	</td>
</tr>
</table>
<!-- debugging
<xsl:call-template name="img-scale">
	<xsl:with-param name="img" select="image[@id='Bild-1']"/>
	<xsl:with-param name="max-width" select="paper/content/@width"/>
	<xsl:with-param name="max-height" select="paper/content/@height"/>
</xsl:call-template>
<br/>
<xsl:call-template name="img-scale">
	<xsl:with-param name="img" select="image[@id='Bild-2']"/>
	<xsl:with-param name="max-width" select="paper/content/@width"/>
	<xsl:with-param name="max-height" select="paper/content/@height"/>
</xsl:call-template>
-->
<br/>

<xsl:call-template name="generic-table">
	<xsl:with-param name="table" select="data/table[@id='camlist']"/>
</xsl:call-template>

</center>

</body>
</html>

</xsl:template>


</xsl:transform>
